// GLOBALE VARIABLE
var urlsinput = 'UI#textarea#URL-Liste';


// BEIM LADEN AUSFÜHREN
document.addEventListener('DOMContentLoaded', function() {
	// Listeners hinzufügen:
	dgel('[name="UI#popup#btn#unterseite"]').forEach(function(el) {
		el.onclick = function(event) {handler.unterseite(event,event.target.getAttribute('wert'));};
	});
	dgel('#'+'UI#popup#anleitung#btn').onclick = function(event) {handler.aufklappen(event.target);};
	dgel('#'+urlsinput).addEventListener('focusout',function() {handler.ui()},false);
	dgel('#'+'UI#btn#output').onclick = function() {handler.openurls();};
	dgel('#'+'UI#btn#urls#reihenfolge').onclick = function() {handler.reverseurlliste();handler.ui();};
	var nodes = document.getElementsByClassName('UI#settings');
	for(var k=0; k<nodes.length; k++) {
		var node = nodes[k];
		node.onchange = function() {handler.ui();};
	}

	// Einmalig ausführen:
	chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'Popup geladen'}, handler.initialisieren);
});


// EVENT HANDLER
var handler = {
	'unterseite': function(event,url) {
		if(event.metaKey || event.ctrlKey) {
			var target = '_blank';
		} else {
			var target = '_self';
		}
		response.unterseite(url,target);
	},
	'initialisieren': function(msg) {
		if(msg == null) return;
		urls = JSON.parse(msg.urls);
		param = JSON.parse(msg.param);
		dgel('#'+urlsinput).value = urls.join('\n');
		dgel('[name="UI#btn#reihenfolge"]').forEach(function(btn) {
			if(JSON.parse(btn.value) === param.fokus) btn.checked = true;
		});
		dgel('#'+'UI#btn#tabsanheften').checked = param.pinned;
		dgel('#'+'UI#btn#pinnedpos').checked = param.pos;
	},
	'ui': function() {
		urls = dgel('#'+urlsinput).value;
		urls = urls.split(/\s+/);
		for(var k=urls.length-1; k>=0; k--) {
		 	if(urls[k] === '') urls.splice(k,1);
		};
		// var regex = / /
		// for(var k=urls.length-1; k>=0; k--) {
		// 	if(false) urls.split(k,1);
		// };
		dgel('#'+urlsinput).value = urls.join('\n');
		dgel('[name="UI#btn#reihenfolge"]').forEach(function(btn) {
			if(btn.checked === true) param.fokus = JSON.parse(btn.value);
		});
		param.pinned = dgel('#'+'UI#btn#tabsanheften').checked;
		param.pos = dgel('#'+'UI#btn#pinnedpos').checked;
		chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'UI aktualisieren', urls: JSON.stringify(urls), param: JSON.stringify(param)});
	},
	'openurls': function() {
		if(urls.length > 0) chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'URLs oeffnen', urls: JSON.stringify(urls), param: JSON.stringify(param)});
	},
	'aufklappen': function(btn) {
		btn.blur;
		var div = document.getElementById('UI#popup#anleitung');
		if(div.style.display == 'none') {
			div.style.display = 'inline-block';
			btn.value = '▲ Anleitung zuklappen'; //müsste mit &#x25B2; klappen.
		} else {
			div.style.display = 'none';
			btn.value = '▼ Anleitung aufklappen'; //müsste mit &#x25BC; klappen.
		}
	},
	reverseurlliste: function() {
		urls = dgel('#'+urlsinput).value;
		urls = urls.split(/\s+/);
		urls.reverse();
		dgel('#'+urlsinput).value = urls.join('\n');
	},
};


// RESPONSE-FUNKTIONEN
var response = {
	'unterseite': function(url,target) {
		chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
			chrome.tabs.sendMessage(tabs[0].id, {from: 'popup.js', to: 'content.js', subject: 'öffne URL!', url:url, target: target});
		});
	},
};